<?php
// --- افزایش محدودیت‌های سرور برای اسکن ---
set_time_limit(600); // افزایش زمان اجرا برای بکاپ
ini_set('memory_limit', '1024M'); // افزایش حافظه برای بکاپ
// -----------------------------------------

// --- فعال‌سازی نمایش خطاها برای دیباگ ---
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
// -----------------------------------------

// --- تنظیمات ---
// لطفاً یک رمز عبور قوی انتخاب کنید
 $password = 'xperformenceleox'; 

// مسیری که می‌خواهید اسکن شود. __DIR__ یعنی همان پوشه‌ای که اسکریپت در آن قرار دارد.
 $scanDirectory = __DIR__;

// بازه زمانی برای تشخیص فایل‌های "اخیراً تغییر کرده" به ثانیه (پیش‌فرض: 24 ساعت = 86400 ثانیه)
 $recentTimeWindow = 86400; 

// مسیر پوشه قرنطینه (این پوشه به صورت خودکار ایجاد می‌شود)
 $quarantineDir = __DIR__ . '/quarantine';

// مسیر پوشه بکاپ (این پوشه به صورت خودکار ایجاد می‌شود)
 $backupDir = __DIR__ . '/backups';

// لیست سفید (فایل‌هایی که نباید اسکن شوند - مسیر کامل از ریشه)
 $whitelist = [
    basename(__FILE__), // فایل اسکنر خودش
];

// --- تنظیمات اسکن وب شل ---
 $suspiciousFunctions = [
    'eval', 'system', 'exec', 'shell_exec', 'passthru', 'proc_open', 'assert',
    'preg_replace_with_e', 'create_function', 'base64_decode', 'str_rot13',
    'phpinfo', 'posix_mkfifo', 'glob', 'file_get_contents', 'file_put_contents',
    'fopen', 'fwrite', 'curl_exec', 'curl_multi_exec', 'parse_ini_file',
    'show_source', 'highlight_file', 'php_uname', 'chmod', 'chown'
];

// الگوهای پیشرفته‌تر برای پیدا کردن کدهای مبهم‌سازی شده
 $suspiciousPatterns = [
    '/eval\s*\(\s*base64_decode\s*\(/i',
    '/eval\s*\(\s*str_rot13\s*\(/i',
    '/eval\s*\(\s*\$\w+\s*\)/i', // eval($variable)
    '/assert\s*\(\s*base64_decode\s*\(/i',
    '/preg_replace\s*\(\s*["\'].*\/e["\']/', // الگوی قدیمی و خطرناک preg_replace
    '/\$_GET\s*\[\s*["\']\w+["\']\s*\]\s*\(/i', // فراخوانی تابع با ورودی GET
    '/\$_POST\s*\[\s*["\']\w+["\']\s*\]\s*\(/i', // فراخوانی تابع با ورودی POST
];

// --- تنظیمات اسکن آسیب‌پذیری ---
 $vulnerabilityPatterns = [
    'unrestricted_filename' => [
        'pattern' => '/\$_FILES\[[\'"].+?[\'"]\]\[[\'"]name[\'"]\]/i',
        'description' => 'استفاده مستقیم از نام فایل کاربر (خطر تغییر پسوند و آپلود وب شل)',
        'risk' => 'بحرانی'
    ],
    'insecure_move_uploaded_file' => [
        'pattern' => '/move_uploaded_file\s*\(\s*\$_FILES\[[\'"].+?[\'"]\]\[[\'"]tmp_name[\'"]\s*,\s*[\'"].+?[\'"]\s*\)/i',
        'description' => 'استفاده ناامن از move_uploaded_file در مسیری قابل دسترس عمومی',
        'risk' => 'بحرانی'
    ],
    'file_inclusion' => [
        'pattern' => '/(include|require|include_once|require_once)\s*\(\s*\$_(GET|POST|REQUEST)\[[\'"].+?[\'"]\]\s*\)/i',
        'description' => 'احتمال آسیب‌پذیری Local/Remote File Inclusion (LFI/RFI)',
        'risk' => 'بالا'
    ],
];

// پسوندهای فایل‌هایی که باید اسکن شوند
 $allowedExtensions = ['php', 'phtml', 'php3', 'php4', 'php5', 'inc', 'js', 'html', 'htm'];

// پوشه‌هایی که باید از اسکن نادیده گرفته شوند
 $excludeDirectories = ['.', '..', '.git', 'vendor', 'node_modules', '.idea', 'cache', 'tmp', $quarantineDir, $backupDir];

// --- پایان تنظیمات ---

// ایجاد پوشه قرنطینه و بکاپ در صورت عدم وجود
if (!file_exists($quarantineDir)) {
    mkdir($quarantineDir, 0755, true);
}
if (!file_exists($backupDir)) {
    mkdir($backupDir, 0755, true);
}

session_start();

// صفحه لاگین
function show_login_form() {
    global $password;
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ورود به مرکز فرماندهی امنیتی</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style> 
            * { box-sizing: border-box; }
            body { font-family: 'Vazirmatn', sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; padding: 20px; }
            .login-container { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); padding: 50px; border-radius: 15px; box-shadow: 0 15px 35px rgba(0,0,0,0.2); text-align: center; width: 100%; max-width: 400px; }
            h2 { color: #333; margin-bottom: 25px; font-weight: 700; }
            input[type="password"] { width: 100%; padding: 15px; margin: 10px 0; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; font-size: 16px; transition: border-color 0.3s; }
            input[type="password"]:focus { border-color: #667eea; outline: none; }
            button { width: 100%; padding: 15px; background-color: #667eea; color: white; border: none; border-radius: 8px; cursor: pointer; font-size: 16px; font-weight: 500; transition: background-color 0.3s, transform 0.2s; }
            button:hover { background-color: #5a67d8; transform: translateY(-2px); }
        </style>
    </head>
    <body>
        <div class="login-container">
            <h2><i class="fas fa-shield-alt"></i> ورود به مرکز فرماندهی امنیتی</h2>
            <form method="post">
                <input type="password" name="password" placeholder="رمز عبور را وارد کنید" required>
                <button type="submit" name="login">ورود</button>
            </form>
        </div>
    </body>
    </html>
    <?php
}

// بررسی احراز هویت
if (isset($_POST['login'])) {
    if ($_POST['password'] === $password) {
        $_SESSION['authenticated'] = true;
    } else {
        $error = "رمز عبور اشتباه است.";
    }
}

if (!isset($_SESSION['authenticated']) || !$_SESSION['authenticated']) {
    show_login_form();
    exit;
}

// --- توابع کمکی ---
function get_wp_version() {
    $version_file = __DIR__ . '/wp-includes/version.php';
    if (file_exists($version_file)) {
        $content = file_get_contents($version_file);
        preg_match('/\$wp_version\s*=\s*[\'"]([^\'"]+)[\'"]/', $content, $matches);
        return isset($matches[1]) ? $matches[1] : false;
    }
    return false;
}

function download_wp_core_file($version, $relative_path) {
    $url = "https://core.svn.wordpress.org/tags/{$version}/{$relative_path}";
    $context = stream_context_create([
        'http' => [
            'timeout' => 20,
            'user_agent' => 'WordPress Security Scanner'
        ]
    ]);
    $data = file_get_contents($url, false, $context);
    return $data;
}

function formatBytes($size, $precision = 2) {
    if ($size == 0) return '0 B';
    $base = log($size, 1024);
    $suffixes = ['B', 'KB', 'MB', 'GB', 'TB'];
    return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
}

// --- پایان بخش اول ---<?php
// --- افزایش محدودیت‌های سرور برای اسکن ---
set_time_limit(600); // افزایش زمان اجرا برای بکاپ
ini_set('memory_limit', '1024M'); // افزایش حافظه برای بکاپ
// -----------------------------------------

// --- فعال‌سازی نمایش خطاها برای دیباگ ---
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
// -----------------------------------------

// --- تنظیمات ---
// لطفاً یک رمز عبور قوی انتخاب کنید
 $password = 'xperformenceleox'; 

// مسیری که می‌خواهید اسکن شود. __DIR__ یعنی همان پوشه‌ای که اسکریپت در آن قرار دارد.
 $scanDirectory = __DIR__;

// بازه زمانی برای تشخیص فایل‌های "اخیراً تغییر کرده" به ثانیه (پیش‌فرض: 24 ساعت = 86400 ثانیه)
 $recentTimeWindow = 86400; 

// مسیر پوشه قرنطینه (این پوشه به صورت خودکار ایجاد می‌شود)
 $quarantineDir = __DIR__ . '/quarantine';

// مسیر پوشه بکاپ (این پوشه به صورت خودکار ایجاد می‌شود)
 $backupDir = __DIR__ . '/backups';

// لیست سفید (فایل‌هایی که نباید اسکن شوند - مسیر کامل از ریشه)
 $whitelist = [
    basename(__FILE__), // فایل اسکنر خودش
];

// --- تنظیمات اسکن وب شل ---
 $suspiciousFunctions = [
    'eval', 'system', 'exec', 'shell_exec', 'passthru', 'proc_open', 'assert',
    'preg_replace_with_e', 'create_function', 'base64_decode', 'str_rot13',
    'phpinfo', 'posix_mkfifo', 'glob', 'file_get_contents', 'file_put_contents',
    'fopen', 'fwrite', 'curl_exec', 'curl_multi_exec', 'parse_ini_file',
    'show_source', 'highlight_file', 'php_uname', 'chmod', 'chown'
];

// الگوهای پیشرفته‌تر برای پیدا کردن کدهای مبهم‌سازی شده
 $suspiciousPatterns = [
    '/eval\s*\(\s*base64_decode\s*\(/i',
    '/eval\s*\(\s*str_rot13\s*\(/i',
    '/eval\s*\(\s*\$\w+\s*\)/i', // eval($variable)
    '/assert\s*\(\s*base64_decode\s*\(/i',
    '/preg_replace\s*\(\s*["\'].*\/e["\']/', // الگوی قدیمی و خطرناک preg_replace
    '/\$_GET\s*\[\s*["\']\w+["\']\s*\]\s*\(/i', // فراخوانی تابع با ورودی GET
    '/\$_POST\s*\[\s*["\']\w+["\']\s*\]\s*\(/i', // فراخوانی تابع با ورودی POST
];

// --- تنظیمات اسکن آسیب‌پذیری ---
 $vulnerabilityPatterns = [
    'unrestricted_filename' => [
        'pattern' => '/\$_FILES\[[\'"].+?[\'"]\]\[[\'"]name[\'"]\]/i',
        'description' => 'استفاده مستقیم از نام فایل کاربر (خطر تغییر پسوند و آپلود وب شل)',
        'risk' => 'بحرانی'
    ],
    'insecure_move_uploaded_file' => [
        'pattern' => '/move_uploaded_file\s*\(\s*\$_FILES\[[\'"].+?[\'"]\]\[[\'"]tmp_name[\'"]\s*,\s*[\'"].+?[\'"]\s*\)/i',
        'description' => 'استفاده ناامن از move_uploaded_file در مسیری قابل دسترس عمومی',
        'risk' => 'بحرانی'
    ],
    'file_inclusion' => [
        'pattern' => '/(include|require|include_once|require_once)\s*\(\s*\$_(GET|POST|REQUEST)\[[\'"].+?[\'"]\]\s*\)/i',
        'description' => 'احتمال آسیب‌پذیری Local/Remote File Inclusion (LFI/RFI)',
        'risk' => 'بالا'
    ],
];

// پسوندهای فایل‌هایی که باید اسکن شوند
 $allowedExtensions = ['php', 'phtml', 'php3', 'php4', 'php5', 'inc', 'js', 'html', 'htm'];

// پوشه‌هایی که باید از اسکن نادیده گرفته شوند
 $excludeDirectories = ['.', '..', '.git', 'vendor', 'node_modules', '.idea', 'cache', 'tmp', $quarantineDir, $backupDir];

// --- پایان تنظیمات ---

// ایجاد پوشه قرنطینه و بکاپ در صورت عدم وجود
if (!file_exists($quarantineDir)) {
    mkdir($quarantineDir, 0755, true);
}
if (!file_exists($backupDir)) {
    mkdir($backupDir, 0755, true);
}

session_start();





// --- پایان بخش اول ---
// --- توابع اسکن ---
function scan_for_shells($dir) {
    global $suspiciousFunctions, $suspiciousPatterns, $allowedExtensions, $excludeDirectories, $recentTimeWindow, $whitelist;
    $results = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    foreach ($iterator as $file) {
        if ($file->isDir() || in_array($file->getFilename(), $excludeDirectories)) continue;
        if (in_array(basename($file->getPathname()), $whitelist)) continue;
        if (!in_array(strtolower(pathinfo($file->getPathname(), PATHINFO_EXTENSION)), $allowedExtensions)) continue;

        $content = file_get_contents($file->getPathname());
        $reasons = [];
        foreach ($suspiciousFunctions as $func) if (stripos($content, $func) !== false) $reasons[] = "تابع مشکوک: <strong>" . htmlspecialchars($func) . "</strong>";
        foreach ($suspiciousPatterns as $pattern) if (preg_match($pattern, $content)) { $reasons[] = "الگوی مشکوک (Regex) یافت شد."; break; }
        
        if (!empty($reasons)) {
            $modTime = $file->getMTime(); $isRecent = (time() - $modTime) < $recentTimeWindow;
            $directory = dirname($file->getPathname());
            if (!isset($results[$directory])) $results[$directory] = [];
            $results[$directory][] = [ 'path' => $file->getPathname(), 'reasons' => implode('<br>', array_unique($reasons)), 'modified' => date('Y-m-d H:i:s', $modTime), 'size' => formatBytes($file->getSize()), 'is_recent' => $isRecent, 'permissions' => substr(sprintf('%o', fileperms($file->getPathname())), -4) ];
        }
    }
    ksort($results);
    return $results;
}

function scan_upload_vulnerabilities($dir) {
    global $vulnerabilityPatterns, $allowedExtensions, $excludeDirectories, $whitelist;
    $results = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    foreach ($iterator as $file) {
        if ($file->isDir() || in_array($file->getFilename(), $excludeDirectories)) continue;
        if (in_array(basename($file->getPathname()), $whitelist)) continue;
        if (!in_array(strtolower(pathinfo($file->getPathname(), PATHINFO_EXTENSION)), $allowedExtensions)) continue;

        $content = file_get_contents($file->getPathname());
        $foundVulns = [];
        foreach ($vulnerabilityPatterns as $type => $vuln) {
            if (preg_match($vuln['pattern'], $content)) {
                $riskColor = ($vuln['risk'] == 'بحرانی') ? '#dc3545' : '#fd7e14';
                $foundVulns[] = "<strong style='color:" . $riskColor . ";'>" . $vuln['risk'] . "</strong>: " . $vuln['description'];
            }
        }
        if (!empty($foundVulns)) {
            $directory = dirname($file->getPathname());
            if (!isset($results[$directory])) $results[$directory] = [];
            $results[$directory][] = [ 'path' => $file->getPathname(), 'reasons' => implode('<br>', $foundVulns), 'modified' => date('Y-m-d H:i:s', $file->getMTime()), 'size' => formatBytes($file->getSize()), 'is_recent' => false, 'permissions' => substr(sprintf('%o', fileperms($file->getPathname())), -4) ];
        }
    }
    ksort($results);
    return $results;
}

function scan_core_integrity($wp_version) {
    global $excludeDirectories, $whitelist;
    $results = [];
    $checksums_url = "https://api.wordpress.org/core/checksums/1.0/?version={$wp_version}&locale=en_US";
    $checksums_json = @file_get_contents($checksums_url);
    if (!$checksums_json) return ['error' => 'Could not fetch checksums from WordPress.org.'];
    
    $checksums = json_decode($checksums_json, true);
    if (!isset($checksums['checksums'])) return ['error' => 'Invalid checksums data.'];

    foreach ($checksums['checksums'] as $file => $official_hash) {
        $local_file = __DIR__ . '/' . $file;
        if (file_exists($local_file) && !in_array(basename($local_file), $whitelist)) {
            $local_hash = md5_file($local_file);
            if ($local_hash !== $official_hash) {
                $directory = dirname($local_file);
                if (!isset($results[$directory])) $results[$directory] = [];
                $results[$directory][] = [ 'path' => $local_file, 'reasons' => "فایل اصلی وردپرس تغییر یافته است. هش رسمی: <strong>{$official_hash}</strong><br>هش محلی: <strong>{$local_hash}</strong>", 'modified' => date('Y-m-d H:i:s', filemtime($local_file)), 'size' => formatBytes(filesize($local_file)), 'is_recent' => false, 'permissions' => substr(sprintf('%o', fileperms($local_file)), -4), 'is_core' => true, 'official_path' => $file ];
            }
        }
    }
    ksort($results);
    return $results;
}

function scan_security_hardening() {
    $results = [];
    $wp_config = __DIR__ . '/wp-config.php';
    
    if (file_exists($wp_config)) {
        $content = file_get_contents($wp_config);
        if (strpos($content, "define('DISALLOW_FILE_EDIT', true);") === false) {
            $results[] = ['path' => $wp_config, 'reasons' => '<strong style="color:orange;">هشدار:</strong> ویرایشگر فایل‌ها در پیشخوان فعال است.', 'modified' => date('Y-m-d H:i:s', filemtime($wp_config)), 'size' => formatBytes(filesize($wp_config))];
        }
        if (preg_match("/\$table_prefix\s*=\s*['\"]wp_['\"]/", $content)) {
            $results[] = ['path' => $wp_config, 'reasons' => '<strong style="color:orange;">هشدار:</strong> از پیشوند پیش‌فرض جداول دیتابیس (wp_) استفاده می‌کنید.', 'modified' => date('Y-m-d H:i:s', filemtime($wp_config)), 'size' => formatBytes(filesize($wp_config))];
        }
    }

    $readme_file = __DIR__ . '/readme.html';
    if (file_exists($readme_file)) {
        $results[] = ['path' => $readme_file, 'reasons' => '<strong style="color:orange;">هشدار:</strong> فایل readme.html نسخه وردپرس شما را فاش می‌کند.', 'modified' => date('Y-m-d H:i:s', filemtime($readme_file)), 'size' => formatBytes(filesize($readme_file))];
    }

    return $results;
}

function scan_by_modification_time($dir, $fromTimestamp, $toTimestamp) {
    global $allowedExtensions, $excludeDirectories, $whitelist;
    $results = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    foreach ($iterator as $file) {
        if ($file->isDir() || in_array($file->getFilename(), $excludeDirectories)) continue;
        if (in_array(basename($file->getPathname()), $whitelist)) continue;
        if (!in_array(strtolower(pathinfo($file->getPathname(), PATHINFO_EXTENSION)), $allowedExtensions)) continue;

        $modTime = $file->getMTime();
        if ($modTime >= $fromTimestamp && $modTime <= $toTimestamp) {
            $directory = dirname($file->getPathname());
            if (!isset($results[$directory])) $results[$directory] = [];
            $results[$directory][] = [ 'path' => $file->getPathname(), 'reasons' => 'ویرایش شده در بازه زمانی درخواستی', 'modified' => date('Y-m-d H:i:s', $modTime), 'size' => formatBytes($file->getSize()), 'is_recent' => false, 'permissions' => substr(sprintf('%o', fileperms($file->getPathname())), -4) ];
        }
    }
    ksort($results);
    return $results;
}

function scan_permissions($dir) {
    global $excludeDirectories, $whitelist;
    $results = [];
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    $dangerousPermissions = ['0777', '0775', '0666'];

    foreach ($iterator as $file) {
        if ($file->isDir() || in_array($file->getFilename(), $excludeDirectories)) continue;
        if (in_array(basename($file->getPathname()), $whitelist)) continue;

        $permissions = substr(sprintf('%o', fileperms($file->getPathname())), -4);
        if (in_array($permissions, $dangerousPermissions)) {
             $directory = dirname($file->getPathname());
            if (!isset($results[$directory])) $results[$directory] = [];
            $results[$directory][] = [ 'path' => $file->getPathname(), 'reasons' => "سطح دسترسی خطرناک: <strong>" . $permissions . "</strong>", 'modified' => date('Y-m-d H:i:s', $file->getMTime()), 'size' => formatBytes($file->getSize()), 'is_recent' => false, 'permissions' => $permissions ];
        }
    }
    ksort($results);
    return $results;
}

// --- پایان بخش دوم ---
// --- اکشن‌ها ---
if (isset($_POST['action']) && $_POST['action'] == 'repair_core' && isset($_POST['file_path']) && isset($_POST['official_path'])) {
    $wp_version = get_wp_version();
    if ($wp_version) {
        $file_to_repair = realpath($_POST['file_path']);
        $scan_dir_real = realpath($scanDirectory);
        if (strpos($file_to_repair, $scan_dir_real) === 0 && is_file($file_to_repair)) {
            $backup_path = $quarantineDir . '/' . basename($file_to_repair) . '_modified_' . time();
            rename($file_to_repair, $backup_path);
            $clean_content = download_wp_core_file($wp_version, $_POST['official_path']);
            if ($clean_content) {
                file_put_contents($file_to_repair, $clean_content);
                $message = "<div class='message success'><i class='fas fa-check-circle'></i> فایل با موفقیت تعمیر شد. نسخه پشتیبان در قرنطینه ذخیره شد.</div>";
            } else {
                rename($backup_path, $file_to_repair);
                $message = "<div class='message error'><i class='fas fa-times-circle'></i> خطا در دانلود فایل اصلی. عملیات لغو شد.</div>";
            }
        } else {
            $message = "<div class='message error'><i class='fas fa-exclamation-triangle'></i> تلاش برای تعمیر یک فایل غیرمجاز.</div>";
        }
    }
}

if (isset($_POST['action']) && $_POST['action'] == 'quarantine' && isset($_POST['file_path'])) {
    $fileToQuarantine = realpath($_POST['file_path']);
    $scanDirReal = realpath($scanDirectory);
    $quarantinePath = $quarantineDir . '/' . basename($fileToQuarantine) . '_' . time();
    if (strpos($fileToQuarantine, $scanDirReal) === 0 && is_file($fileToQuarantine)) {
        if (rename($fileToQuarantine, $quarantinePath)) {
            $message = "<div class='message success'><i class='fas fa-check-circle'></i> فایل با موفقیت به قرنطینه منتقل شد.</div>";
        } else {
            $message = "<div class='message error'><i class='fas fa-times-circle'></i> خطا در انتقال فایل به قرنطینه.</div>";
        }
    } else {
        $message = "<div class='message error'><i class='fas fa-exclamation-triangle'></i> تلاش برای انتقال یک فایل غیرمجاز.</div>";
    }
}

if (isset($_POST['action']) && $_POST['action'] == 'delete' && isset($_POST['file_path'])) {
    $fileToDelete = realpath($_POST['file_path']);
    $scanDirReal = realpath($scanDirectory);
    if (strpos($fileToDelete, $scanDirReal) === 0 && is_file($fileToDelete)) {
        if (unlink($fileToDelete)) {
            $message = "<div class='message success'><i class='fas fa-check-circle'></i> فایل با موفقیت حذف شد.</div>";
        } else {
            $message = "<div class='message error'><i class='fas fa-times-circle'></i> خطا در حذف فایل.</div>";
        }
    } else {
        $message = "<div class='message error'><i class='fas fa-exclamation-triangle'></i> تلاش برای حذف یک فایل غیرمجاز.</div>";
    }
}

if (isset($_POST['action']) && $_POST['action'] == 'change_perms' && isset($_POST['file_path']) && isset($_POST['new_perms'])) {
    $fileToChange = realpath($_POST['file_path']);
    $scanDirReal = realpath($scanDirectory);
    $newPerms = $_POST['new_perms'];
    if (strpos($fileToChange, $scanDirReal) === 0 && is_file($fileToChange) && preg_match('/^[0-7]{4}$/', $newPerms)) {
        if (chmod($fileToChange, octdec($newPerms))) {
            $message = "<div class='message success'><i class='fas fa-check-circle'></i> سطح دسترسی فایل با موفقیت به {$newPerms} تغییر یافت.</div>";
        } else {
            $message = "<div class='message error'><i class='fas fa-times-circle'></i> خطا در تغییر سطح دسترسی فایل.</div>";
        }
    } else {
        $message = "<div class='message error'><i class='fas fa-exclamation-triangle'></i> درخواست نامعتبر برای تغییر سطح دسترسی.</div>";
    }
    header("Location: " . basename(__FILE__));
    exit;
}

if (isset($_POST['action']) && $_POST['action'] == 'create_backup') {
    if (!class_exists('ZipArchive')) {
        $message = "<div class='message error'><i class='fas fa-times-circle'></i> افزونه ZipArchive در PHP شما فعال نیست. امکان ایجاد بکاپ وجود ندارد.</div>";
    } else {
        $zip = new ZipArchive();
        $backupFilename = 'backup_' . date('Y-m-d_H-i-s') . '.zip';
        $backupPath = $backupDir . '/' . $backupFilename;

        if ($zip->open($backupPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
            $rootPath = realpath($scanDirectory);
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($rootPath), RecursiveIteratorIterator::SELF_FIRST);
            foreach ($files as $file) {
                if (!$file->isDir() && !in_array($file->getFilename(), $excludeDirectories)) {
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($rootPath) + 1);
                    $zip->addFile($filePath, $relativePath);
                }
            }
            $zip->close();
            $_SESSION['backup_file'] = $backupFilename;
            $message = "<div class='message success'><i class='fas fa-check-circle'></i> بکاپ با موفقیت ایجاد شد: <strong>{$backupFilename}</strong></div>";
        } else {
            $message = "<div class='message error'><i class='fas fa-times-circle'></i> خطا در ایجاد فایل بکاپ.</div>";
        }
    }
    header("Location: " . basename(__FILE__));
    exit;
}

if (isset($_GET['action']) && $_GET['action'] == 'view' && isset($_GET['file_path'])) {
    $fileToView = realpath($_GET['file_path']);
    $scanDirReal = realpath($scanDirectory);
    if (strpos($fileToView, $scanDirReal) === 0 && is_file($fileToView)) {
        $content = file_get_contents($fileToView);
        ?>
        <!DOCTYPE html>
        <html lang="fa" dir="rtl">
        <head>
            <meta charset="UTF-8">
            <title>مشاهده فایل</title>
            <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
            <style>
                body { font-family: 'Vazirmatn', sans-serif; background: #2d2d2d; color: #ccc; margin: 0; padding: 20px; }
                .container { background: #1e1e1e; padding: 20px; border-radius: 8px; }
                h2 { color: #fff; border-bottom: 1px solid #444; padding-bottom: 10px; }
                pre { background: #000; padding: 20px; border-radius: 5px; overflow-x: auto; white-space: pre-wrap; word-wrap: break-word; line-height: 1.6; }
                a { color: #667eea; text-decoration: none; font-weight: 500; }
                a:hover { text-decoration: underline; }
            </style>
        </head>
        <body>
            <div class="container">
                <h2><i class="fas fa-file-code"></i> مشاهده فایل: <?php echo htmlspecialchars($fileToView); ?></h2>
                <pre><?php echo htmlspecialchars($content); ?></pre>
                <hr style="border-color: #444;">
                <p><a href="?"><i class="fas fa-arrow-left"></i> بازگشت به نتایج</a></p>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// --- منطق اصلی ---
 $wp_version = get_wp_version();
 $scan_results = [];
 $scan_type = '';
if (isset($_POST['start_scan'])) { $scan_results = scan_for_shells($scanDirectory); $scan_type = 'suspicious'; }
elseif (isset($_POST['start_vuln_scan'])) { $scan_results = scan_upload_vulnerabilities($scanDirectory); $scan_type = 'vulnerability'; }
elseif (isset($_POST['start_core_scan']) && $wp_version) { $scan_results = scan_core_integrity($wp_version); $scan_type = 'core'; }
elseif (isset($_POST['start_hardening_scan'])) { $scan_results = scan_security_hardening(); $scan_type = 'hardening'; }
elseif (isset($_POST['start_time_scan'])) {
    $fromDate = $_POST['from_date'];
    $toDate = $_POST['to_date'];
    $fromTimestamp = strtotime($fromDate . ' 00:00:00');
    $toTimestamp = strtotime($toDate . ' 23:59:59');
    $scan_results = scan_by_modification_time($scanDirectory, $fromTimestamp, $toTimestamp);
    $scan_type = 'time';
}
elseif (isset($_POST['start_perm_scan'])) { $scan_results = scan_permissions($scanDirectory); $scan_type = 'permissions'; }

// اکشن دانلود گزارش CSV (اصلاح شده)
if (isset($_POST['action']) && $_POST['action'] == 'download_csv' && !empty($scan_results)) {
    if (headers_sent()) {
        die("خطا: هدرها قبلا ارسال شده‌اند.");
    }
    ob_start();
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="scan_report_' . date('Y-m-d_H-i-s') . '.csv"');
    $output = fopen('php://output', 'w');
    fwrite($output, "\xEF\xBB\xBF"); // BOM برای درست نمایش کاراکترهای فارسی در اکسل
    fputcsv($output, ['نوع اسکن', 'پوشه', 'نام فایل', 'دلیل', 'آخرین ویرایش', 'حجم', 'سطح دسترسی']);
    foreach ($scan_results as $directory => $files) {
        foreach ($files as $file) {
            fputcsv($output, [$scan_type, $directory, basename($file['path']), strip_tags($file['reasons']), $file['modified'], $file['size'], isset($file['permissions']) ? $file['permissions'] : 'N/A']);
        }
    }
    fclose($output);
    ob_end_flush();
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مرکز فرماندهی امنیت وردپرس</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * { box-sizing: border-box; }
        body { font-family: 'Vazirmatn', sans-serif; background: #f4f7f6; margin: 0; padding: 20px; color: #333; }
        .container { max-width: 1400px; margin: auto; background: white; border-radius: 12px; box-shadow: 0 8px 25px rgba(0,0,0,0.1); overflow: hidden; }
        header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; }
        header h1 { margin: 0; font-size: 28px; font-weight: 700; }
        header p { margin-top: 5px; opacity: 0.9; }
        main { padding: 30px; }
        .warning, .message { padding: 15px 20px; margin-bottom: 20px; border-radius: 5px; display: flex; align-items: center; }
        .warning { background: #fff3cd; border-right: 5px solid #ffc107; color: #856404; }
        .message.success { background: #d4edda; border-right: 5px solid #28a745; color: #155724; }
        .message.error { background: #f8d7da; border-right: 5px solid #dc3545; color: #721c24; }
        .warning i, .message i { font-size: 20px; margin-left: 15px; }
        .wp-info { background: #e7f3ff; border: 1px solid #b3d9ff; padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center; }
        .wp-info strong { color: #0056b3; }
        .tabs { display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 2px solid #dee2e6; overflow-x: auto; }
        .tab-link { padding: 15px 25px; background: #f8f9fa; border: 1px solid #dee2e6; border-bottom: none; margin-right: 5px; cursor: pointer; border-radius: 8px 8px 0 0; font-weight: 500; white-space: nowrap; }
        .tab-link.active { background: white; border-bottom: 2px solid white; margin-bottom: -2px; }
        .tab-content { display: none; padding: 20px 0; }
        .tab-content.active { display: block; }
        .scan-controls { display: flex; flex-wrap: wrap; gap: 20px; justify-content: center; margin-bottom: 30px; }
        .scan-form { background: #f8f9fa; padding: 20px; border-radius: 8px; border: 1px solid #dee2e6; flex: 1; min-width: 280px; }
        .scan-form h3 { margin-top: 0; color: #495057; }
        .scan-form-group { display: flex; gap: 10px; align-items: center; margin-bottom: 10px; }
        .scan-form-group label { font-weight: 500; }
        .scan-form-group input { flex-grow: 1; padding: 10px; border: 1px solid #ced4da; border-radius: 5px; }
        .scan-btn { padding: 12px 25px; font-size: 16px; font-weight: 500; cursor: pointer; border: none; border-radius: 50px; color: white; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); transition: transform 0.2s, box-shadow 0.2s; width: 100%; margin-top: 10px;}
        .scan-btn:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4); }
        .scan-btn.vuln-btn { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .scan-btn.core-btn { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
        .scan-btn.hardening-btn { background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); }
        .scan-btn.time-btn { background: linear-gradient(135deg, #fa709a 0%, #fee140 100%); }
        .scan-btn.perm-btn { background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%); color: #333; }
        .scan-btn.backup-btn { background: linear-gradient(135deg, #ffecd2 0%, #fcb69f 100%); color: #333; }
        .scan-btn i { margin-left: 8px; }
        .results-summary { background: #e9ecef; padding: 15px 20px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; line-height: 1.6; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; }
        .results-summary div { flex-grow: 1; }
        .results-summary form { margin: 0; }
        .results-summary i { margin-left: 10px; }
        .directory-group { margin-bottom: 40px; border: 1px solid #dee2e6; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.05); }
        .directory-header { background: #6c757d; color: white; padding: 12px 20px; font-weight: 500; font-size: 16px; }
        .directory-header i { margin-left: 10px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #dee2e6; }
        th { background-color: #f8f9fa; font-weight: 600; }
        tr:last-child td { border-bottom: none; }
        .actions { white-space: nowrap; }
        .actions a, .actions form { display: inline-block; margin: 0 3px; }
        .action-btn { padding: 6px 10px; border-radius: 5px; color: white; text-decoration: none; font-size: 13px; transition: background-color 0.2s; display: inline-block; }
        .action-btn.view { background-color: #17a2b8; }
        .action-btn.view:hover { background-color: #138496; }
        .action-btn.download { background-color: #28a745; }
        .action-btn.download:hover { background-color: #218838; }
        .action-btn.delete { background-color: #dc3545; border: none; cursor: pointer; font-family: 'Vazirmatn', sans-serif; font-weight: 500; }
        .action-btn.delete:hover { background-color: #c82333; }
        .action-btn.quarantine { background-color: #6f42c1; border: none; cursor: pointer; font-family: 'Vazirmatn', sans-serif; font-weight: 500; }
        .action-btn.quarantine:hover { background-color: #5a32a3; }
        .action-btn.repair { background-color: #28a745; border: none; cursor: pointer; font-family: 'Vazirmatn', sans-serif; font-weight: 500; }
        .action-btn.repair:hover { background-color: #218838; }
        .action-btn.chperm { background-color: #fd7e14; border: none; cursor: pointer; font-family: 'Vazirmatn', sans-serif; font-weight: 500; color: #212529;}
        .action-btn.chperm:hover { background-color: #e8680a; }
        .no-results { text-align: center; padding: 40px; color: #6c757d; }
        .no-results i { font-size: 48px; margin-bottom: 15px; display: block; }
        footer { text-align: center; padding: 20px; background: #f8f9fa; border-top: 1px solid #dee2e6; }
        footer a { color: #dc3545; font-weight: 500; text-decoration: none; }
        footer a:hover { text-decoration: underline; }
        .recent-file { background-color: #f8d7da; border-right: 4px solid #dc3545; }
        .recent-file td { border-bottom-color: #f5c6cb; }
        .backup-link { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 5px; text-align: center; margin-bottom: 20px; }
        .backup-link a { color: #155724; font-weight: 700; text-decoration: none; }
        .backup-link a:hover { text-decoration: underline; }
        .perm-form { display: flex; gap: 5px; }
        .perm-form input { width: 60px; padding: 4px; border: 1px solid #ced4da; border-radius: 3px; text-align: center; }
        @media screen and (max-width: 768px) { main { padding: 15px; } .scan-controls { flex-direction: column; } .scan-form { min-width: 100%; } .scan-btn { width: 100%; margin-top: 10px; } table, thead, tbody, th, td, tr { display: block; } thead tr { position: absolute; top: -9999px; left: -9999px; } tr { border: 1px solid #ccc; margin-bottom: 15px; border-radius: 5px; } td { border: none; border-bottom: 1px solid #eee; position: relative; padding-right: 35% !important; text-align: right; } td:before { position: absolute; top: 15px; right: 15px; width: 30%; padding-right: 10px; white-space: nowrap; font-weight: bold; color: #495057; content: attr(data-label); } td.actions { display: flex; justify-content: flex-start; padding: 10px 15px !important; gap: 5px; flex-wrap: wrap; } td.actions:before { content: "اقدامات"; width: auto; } .directory-header { font-size: 14px; } }
    </style>
</head>
<body>
<div class="container">
    <header>
        <h1><i class="fas fa-shield-virus"></i> مرکز فرماندهی امنیت وردپرس</h1>
        <p>نسخه نهایی با تمام قابلیت‌های امنیتی و مدیریتی</p>
    </header>
    <main>
        <div class="warning"> <i class="fas fa-exclamation-triangle"></i> <div><strong>هشدار بسیار مهم:</strong> این ابزار فایل‌ها را تغییر می‌دهد. قبل از هر اقدامی، از سایت خود نسخه پشتیبان تهیه کنید. پس از اتمام کار، این فایل اسکریپت را فوراً از سرور حذف نمایید.</div> </div>
        <?php if (isset($message)) echo $message; ?>
        <?php if($wp_version): ?><div class="wp-info">نسخه وردپرس شما: <strong><?php echo $wp_version; ?></strong></div><?php else: ?><div class="message error"><i class="fas fa-exclamation-triangle"></i> وردپرس در این مسیر شناسایی نشد.</div><?php endif; ?>

        <ul class="tabs">
            <li class="tab-link active" onclick="openTab(event, 'malware-tab')"><i class="fas fa-bug"></i> اسکن بدافزار</li>
            <li class="tab-link" onclick="openTab(event, 'vuln-tab')"><i class="fas fa-radiation"></i> اسکن آسیب‌پذیری</li>
            <?php if($wp_version): ?><li class="tab-link" onclick="openTab(event, 'core-tab')"><i class="fas fa-tools"></i> تعمیر هسته</li><?php endif; ?>
            <li class="tab-link" onclick="openTab(event, 'hardening-tab')"><i class="fas fa-shield-alt"></i> سخت‌سازی</li>
            <li class="tab-link" onclick="openTab(event, 'time-tab')"><i class="fas fa-clock"></i> اسکن زمانی</li>
            <li class="tab-link" onclick="openTab(event, 'perm-tab')"><i class="fas fa-key"></i> اسکن دسترسی</li>
            <li class="tab-link" onclick="openTab(event, 'backup-tab')"><i class="fas fa-archive"></i> پشتیبان‌گیری</li>
        </ul>

        <div id="malware-tab" class="tab-content active"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-bug"></i> اسکن توابع مشکوک</h3><form method="post"><button type="submit" name="start_scan" class="scan-btn"><i class="fas fa-search"></i> شروع اسکن وب شل</button></form></div></div></div>
        <div id="vuln-tab" class="tab-content"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-radiation"></i> اسکن آسیب‌پذیری</h3><form method="post"><button type="submit" name="start_vuln_scan" class="scan-btn vuln-btn"><i class="fas fa-radiation"></i> شروع اسکن آسیب‌پذیری</button></form></div></div></div>
        <div id="core-tab" class="tab-content"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-tools"></i> تعمیر فایل‌های اصلی وردپرس</h3><p>این اسکنر فایل‌های اصلی وردپرس را با نسخه رسمی مقایسه کرده و تغییرات را شناسایی می‌کند.</p><form method="post"><button type="submit" name="start_core_scan" class="scan-btn core-btn"><i class="fas fa-search"></i> شروع بررسی یکپارچگی هسته</button></form></div></div></div>
        <div id="hardening-tab" class="tab-content"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-shield-alt"></i> سخت‌سازی امنیتی</h3><p>این بخش مواردی را بررسی می‌کند که می‌توانند امنیت سایت شما را بهبود بخشند.</p><form method="post"><button type="submit" name="start_hardening_scan" class="scan-btn hardening-btn"><i class="fas fa-search"></i> شروع بررسی سخت‌سازی</button></form></div></div></div>
        <div id="time-tab" class="tab-content"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-clock"></i> اسکن بر اساس زمان تغییر</h3><form method="post"><div class="scan-form-group"><label for="from_date">از:</label><input type="date" id="from_date" name="from_date" value="<?php echo date('Y-m-d', strtotime('-7 days')); ?>" required></div><div class="scan-form-group"><label for="to_date">تا:</label><input type="date" id="to_date" name="to_date" value="<?php echo date('Y-m-d'); ?>" required></div><button type="submit" name="start_time_scan" class="scan-btn time-btn"><i class="fas fa-history"></i> نمایش فایل‌ها</button></form></div></div></div>
        <div id="perm-tab" class="tab-content"><div class="scan-controls"><div class="scan-form"><h3><i class="fas fa-key"></i> اسکن سطح دسترسی</h3><p>این اسکنر فایل‌هایی با سطح دسترسی خطرناک (مثل 777, 666) را پیدا کرده و به شما هشدار می‌دهد.</p><form method="post"><button type="submit" name="start_perm_scan" class="scan-btn perm-btn"><i class="fas fa-key"></i> شروع اسکن دسترسی</button></form></div></div></div>
        
        <div id="backup-tab" class="tab-content">
            <div class="scan-controls">
                <div class="scan-form">
                    <h3><i class="fas fa-archive"></i> ایجاد پشتیبان کامل از سایت</h3>
                    <p>این گزینه یک فایل فشرده (zip) از کل پوشه <?php echo htmlspecialchars($scanDirectory); ?> ایجاد می‌کند. این فرآیند ممکن است بسته به حجم سایت، زمان‌بر باشد.</p>
                    <form method="post">
                        <button type="submit" name="action" value="create_backup" class="scan-btn backup-btn">
                            <i class="fas fa-download"></i> ایجاد فایل پشتیبان کامل
                        </button>
                    </form>
                    <?php if (isset($_SESSION['backup_file'])): ?>
                        <div class="backup-link">
                            فایل بکاپ شما آماده است: <a href="<?php echo $backupDir . '/' . $_SESSION['backup_file']; ?>" download><?php echo $_SESSION['backup_file']; ?></a>
                            <br><small>پس از دانلود، این فایل را از سرور حذف کنید.</small>
                        </div>
                        <?php unset($_SESSION['backup_file']); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php if (!empty($scan_results)): ?>
            <?php if (isset($scan_results['error'])): ?>
                <div class="message error"><?php echo $scan_results['error']; ?></div>
            <?php else: ?>
                <div class="results-summary">
                    <div>
                        <?php
                        $scan_type_text = '';
                        switch($scan_type) {
                            case 'suspicious': $scan_type_text = "در مجموع " . count($scan_results) . " پوشه حاوی فایل‌های مشکوک یافت شد."; break;
                            case 'vulnerability': $scan_type_text = "در مجموع " . count($scan_results) . " پوشه حاوی کدهای آسیب‌پذیر یافت شد."; break;
                            case 'core': $scan_type_text = "تعداد " . count($scan_results) . " فایل اصلی تغییر یافته یافت شد."; break;
                            case 'hardening': $scan_type_text = "تعداد " . count($scan_results) . " مورد برای بهبود امنیت یافت شد."; break;
                            case 'time': $scan_type_text = "فایل‌های ویرایش شده از تاریخ <strong>" . htmlspecialchars($_POST['from_date']) . "</strong> تا <strong>" . htmlspecialchars($_POST['to_date']) . "</strong> در " . count($scan_results) . " پوشه یافت شد."; break;
                            case 'permissions': $scan_type_text = "در مجموع " . count($scan_results) . " پوشه حاوی فایل‌های با سطح دسترسی خطرناک یافت شد."; break;
                        }
                        echo "<i class='fas fa-exclamation-circle'></i> <span>{$scan_type_text}</span>";
                        if ($scan_type === 'suspicious') echo "<br><small><i class='fas fa-info-circle'></i> فایل‌هایی که در ۲۴ ساعت گذشته تغییر کرده‌اند، با هایلایت قرمز مشخص شده‌اند.</small>";
                        ?>
                    </div>
                    <form method="post">
                        <input type="hidden" name="action" value="download_csv">
                        <button type="submit" class="action-btn download" style="padding: 10px 20px; font-size: 14px; border-radius: 5px;">
                            <i class="fas fa-file-csv"></i> دانلود گزارش CSV
                        </button>
                    </form>
                </div>
                <?php foreach ($scan_results as $directory => $files): ?>
                    <div class="directory-group">
                        <div class="directory-header"><i class="fas fa-folder"></i> <?php echo htmlspecialchars($directory); ?></div>
                        <table>
                            <thead><tr><th>نام فایل</th><th>جزئیات</th><th>آخرین ویرایش</th><th>حجم</th><th>اقدامات</th></tr></thead>
                            <tbody>
                                <?php foreach ($files as $file): ?>
                                    <tr class="<?php echo $file['is_recent'] ? 'recent-file' : ''; ?>">
                                        <td data-label="نام فایل"><?php echo htmlspecialchars(basename($file['path'])); ?></td>
                                        <td data-label="جزئیات"><?php echo $file['reasons']; ?></td>
                                        <td data-label="آخرین ویرایش"><?php echo $file['modified']; ?></td>
                                        <td data-label="حجم"><?php echo $file['size']; ?></td>
                                        <td class="actions" data-label="اقدامات">
                                            <a href="?action=view&file_path=<?php echo urlencode($file['path']); ?>" class="action-btn view" target="_blank" title="مشاهده"><i class="fas fa-eye"></i></a>
                                            <a href="?action=download&file_path=<?php echo urlencode($file['path']); ?>" class="action-btn download" title="دانلود"><i class="fas fa-download"></i></a>
                                            <form method="post" style="display:inline-block;" class="perm-form" onsubmit="return confirm('مطمئن به تغییر سطح دسترسی هستید؟');">
                                                <input type="hidden" name="action" value="change_perms">
                                                <input type="hidden" name="file_path" value="<?php echo htmlspecialchars($file['path']); ?>">
                                                <input type="text" name="new_perms" value="<?php echo isset($file['permissions']) ? $file['permissions'] : '0644'; ?>" placeholder="مثلا 0644" title="مثلا 0644">
                                                <button type="submit" class="action-btn chperm" title="تغییر دسترسی"><i class="fas fa-key"></i></button>
                                            </form>
                                            <?php if (isset($file['is_core']) && $file['is_core']): ?>
                                                <form method="post" style="display:inline-block;" onsubmit="return confirm('آیا از تعمیر این فایل اطمینان دارید؟');">
                                                    <input type="hidden" name="action" value="repair_core">
                                                    <input type="hidden" name="file_path" value="<?php echo htmlspecialchars($file['path']); ?>">
                                                    <input type="hidden" name="official_path" value="<?php echo htmlspecialchars($file['official_path']); ?>">
                                                    <button type="submit" class="action-btn repair" title="تعمیر"><i class="fas fa-tools"></i></button>
                                                </form>
                                            <?php endif; ?>
                                            <form method="post" style="display:inline-block;" onsubmit="return confirm('آیا از انتقال این فایل به قرنطینه مطمئن هستید؟');">
                                                <input type="hidden" name="action" value="quarantine">
                                                <input type="hidden" name="file_path" value="<?php echo htmlspecialchars($file['path']); ?>">
                                                <button type="submit" class="action-btn quarantine" title="قرنطینه"><i class="fas fa-biohazard"></i></button>
                                            </form>
                                            <form method="post" style="display:inline-block;" onsubmit="return confirm('آیا از حذف این فایل مطمئن هستید؟');">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="file_path" value="<?php echo htmlspecialchars($file['path']); ?>">
                                                <button type="submit" class="action-btn delete" title="حذف"><i class="fas fa-trash-alt"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        <?php elseif (isset($_POST['start_scan']) || isset($_POST['start_vuln_scan']) || isset($_POST['start_core_scan']) || isset($_POST['start_hardening_scan']) || isset($_POST['start_time_scan']) || isset($_POST['start_perm_scan'])): ?>
            <div class="no-results">
                <i class="fas fa-check-circle"></i>
                <h3>هیچ موردی یافت نشد!</h3>
                <p>به نظر می‌رسد سایت شما از این نظر امن است.</p>
            </div>
        <?php endif; ?>
    </main>
    <footer><p><a href="?action=logout"><i class="fas fa-sign-out-alt"></i> خروج از پنل</a></p></footer>
</div>

<script>
function openTab(evt, tabName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tab-content");
    for (i = 0; i < tabcontent.length; i++) { tabcontent[i].style.display = "none"; }
    tablinks = document.getElementsByClassName("tab-link");
    for (i = 0; i < tablinks.length; i++) { tablinks[i].className = tablinks[i].className.replace(" active", ""); }
    document.getElementById(tabName).style.display = "block";
    evt.currentTarget.className += " active";
}
</script>

</body>
</html>

<?php
// اکشن خروج
if (isset($_GET['action']) && $_GET['action'] == 'logout') {
    session_destroy();
    header('Location: ' . basename(__FILE__));
    exit;
}
?>